
/*Bibliothek für die Ansteuerung einer LCD Anzeige mit 4Bit.
 Ist das Symbol OLED definiert, dann wird die OLED-Anzeige aktiviert.
 Der Unterschied liegt nur in den Verzögerungszeiten*/
#ifndef _LCD_Anzeige_
#define _LCD_Anzeige_

#include "./warte.h"	//Verzögerungen, Warteschleifen

//Definitionen eventuell anpassen
//PD4 ... PD7 sind oberes Nibble für Anzeige
#define LCD_PORT PORTD
#define LCD_PORT_DDR DDRD
#define LCD_EN 3
#define LCD_RS 2
#define UNBENUTZTES_BIT_1 1
#define UNBENUTZTES_BIT_0 0
//Ende der anzupassenden Definitionen

#define LCD_ANZEIGE_LEER 	(_BV(0))
#define LCD_CURSOR_ANFANG	(_BV(1))
#define LCD_ANZEIGE_AN		(_BV(3) | _BV(2))
#define LCD_ANZEIGE_AUS		(_BV(3) & ~_BV(2))
#define LCD_CURSOR_AN		(_BV(3) | _BV(1))
#define LCD_CURSOR_AUS		(_BV(3) & ~_BV(1))
#define LCD_BLINKEN_AN		(_BV(3) | _BV(0))
#define LCD_BLINKEN_AUS		(_BV(3) & ~_BV(0))

#define _lcd_aus_p(B,P) \
    	P=(P & ((1<<UNBENUTZTES_BIT_0) | (1<<UNBENUTZTES_BIT_1))) \
      	| (B & ~((1<<UNBENUTZTES_BIT_0) | (1<<UNBENUTZTES_BIT_1)))

#define _lcd_toggle_EN() \
	LCD_PORT |= (1<<LCD_EN); \
	LCD_PORT &= ~(1<<LCD_EN);
	
//Unterprogramme
void _lcd_schreibe_KOMM(uint8_t byte);
void lcd_cls();
void lcd_aus();
void lcd_an();
void lcd_anfang();
void _lcd_schreibe_DAT(uint8_t zeichen);
void _lcd_cursor_xy(uint8_t x,uint8_t y);
void Lcd_Ausgabe_Byte(uint8_t x, uint8_t y, uint8_t byte);
void Lcd_Ausgabe_String(uint8_t x, uint8_t y, char *text);
void Lcd_Init();
//Ende Unterprogramme


//Anzeige
void _lcd_schreibe_KOMM(uint8_t byte)
/*Schickt das Byte als Kommando zur LCD-Anzeige*/
{
	_lcd_aus_p((byte & 0xf0) & ~(1<<LCD_RS), LCD_PORT); //oberes Nibble + RS=0
	_lcd_toggle_EN();
	_lcd_aus_p((byte << 4) & ~(1<<LCD_RS), LCD_PORT); //unteres Nibble + RS=0
	_lcd_toggle_EN();
#ifndef OLED	
	warte_us(40);
#endif
}

void lcd_cls()
/*Löscht die Anzeige*/
{
	_lcd_schreibe_KOMM(LCD_ANZEIGE_LEER);
#ifdef OLED	
	warte_us(7000);
#else
	warte_us(2000);
#endif

}

void lcd_aus()
//Schaltet Anzeige aus
{
	_lcd_schreibe_KOMM(LCD_ANZEIGE_AUS | LCD_CURSOR_AUS | LCD_BLINKEN_AUS);
}

void lcd_an()
//Schaltet Anzeige ein
{
	_lcd_schreibe_KOMM(LCD_ANZEIGE_AN | LCD_CURSOR_AUS | LCD_BLINKEN_AUS);
#ifndef OLED
	warte_us(2000);
#endif
}

void lcd_anfang()
/*Cursor an den Anfang setzen (Position 0,0 links oben)*/
{
	_lcd_schreibe_KOMM(LCD_CURSOR_ANFANG);
#ifndef OLED
	warte_us(2000);
#endif
}

void _lcd_schreibe_DAT(uint8_t zeichen)
/*Gibt ein Zeichen aus, die Stelle mu�vorher mit _lcd_cursor_xy festgelegt werden*/
{
	_lcd_aus_p(((zeichen & 0xf0) | (1<<LCD_RS)), LCD_PORT); //oberes Nibble ausgeben + RS=1
	_lcd_toggle_EN();
	_lcd_aus_p((zeichen << 4 | (1<<LCD_RS)), LCD_PORT); //unteres Nibble ausgeben + RS=!
	_lcd_toggle_EN();
#ifndef OLED
	warte_us(40);
#endif
}

void _lcd_cursor_xy(uint8_t x,uint8_t y)
/*Setzt Cursor an die Stelle Spalte x (0 ... 15); Zeile y (0 ... 1); 0, 0 ist oben links*/
{
	uint8_t adresse=0;
	if (y==0) adresse=x;
	if (y==1) adresse=x + 0x40;
	_lcd_schreibe_KOMM(_BV(7) | adresse);
}

void Lcd_Ausgabe_Byte(uint8_t x, uint8_t y, uint8_t byte)
/*Schreibt das Datum byte an die Adresse x, y*/
{
	_lcd_cursor_xy(x,y);
	_lcd_schreibe_DAT(byte);
}

void Lcd_Ausgabe_String(uint8_t x, uint8_t y, char *text)
/*Schreibt Text ab Position x(Spalte, y(Zeile), Vektor *text muß�auf Textposition zeigen*/
{
	_lcd_cursor_xy(x,y);	//Ausgabe auf Position setzen
	while (*text)
		{
		_lcd_schreibe_DAT(*text);
		text++;
		}
}

void Lcd_Init()
{
	_lcd_aus_p(0xff,LCD_PORT_DDR); //Alle Port-Bits als Ausgänge
    	warte_us(20000); //Warte 20ms
    	_lcd_aus_p(0x30, LCD_PORT);
    	_lcd_toggle_EN(); warte_us(5000); //�Übernahme und 5ms warten
     	_lcd_aus_p(0x30, LCD_PORT);
    	_lcd_toggle_EN(); warte_us(100); //�Übernahme und 100us warten
     	_lcd_aus_p(0x30, LCD_PORT);
    	_lcd_toggle_EN(); warte_us(40); //�Übernahme und 40us warten
     	_lcd_aus_p(0x20, LCD_PORT); //4 Bit Schnittstelle
    	_lcd_toggle_EN(); warte_us(40); //�Übernahme und 40us warten
    	_lcd_schreibe_KOMM(0x28); //2 Zeilen, 5x7 Punkte Matrix, Standardfont
    	_lcd_schreibe_KOMM(0x08); //Anzeige aus
    	_lcd_schreibe_KOMM(0x06); //Cursor inkrementieren
	_lcd_schreibe_KOMM(0x17);	//Zeichen Mode, interne Helligkeit für OLED; ansonsten Cursor nach rechts bewegen
	lcd_cls(); //lösche Anzeigen
    	lcd_anfang(); //setze Cursor an den Anfang
    	lcd_an();
}


#endif



