#ifndef _I2C_
#define _I2C_
/*Programm zum Schreiben und einlesen der Daten auf einem Zwei-Draht-Bus(I2C) mit 100kHz.
 Zur Anpassung an das Gerät muß der Port, das SDA und das SCL Bit geändert werden. */


#include "./warte.h"
#include "./twimaster.c"
#include "./i2cmaster.h"

#define ACK 0
#define NACK 1
uint8_t Fehler1 = 0x11;

//Unterprogramme
uint8_t Schreibe_Byte(uint8_t Aus_Byte);
uint8_t Lese_Byte(uint8_t Bestaetigung);
uint8_t Lese_Byte_von_Adresse(uint8_t Adresse_Geraet, uint16_t Adresse, uint8_t Adresse8_16);
void Schreibe_Byte_an_Adresse(uint8_t Adresse_Geraet, uint16_t Adresse, uint8_t Wert, uint8_t Adresse8_16);
void Schreibe_Byts_ab_Adresse(uint8_t Adresse_Geraet, uint16_t Adresse, uint8_t Wert[], uint8_t Anzahl, uint8_t Adresse8_16);
void Lese_Byts_ab_Adresse(uint8_t Adresse_Geraet, uint16_t Adresse, uint8_t Wert[], uint8_t Anzahl, uint8_t Adresse8_16);
//Ende Unterprogramme



uint8_t Schreibe_Byte(uint8_t Aus_Byte)
//Schreiben eines Bytes auf den Zweidrahtbus mit anschließender Bestätigung des Empfänders
//Rückgabe 0 erfolgreich, Rückgabe 1 Fehler
{
	return (i2c_write(Aus_Byte));
}

uint8_t Lese_Byte(uint8_t Bestaetigung)
/*Liest ein Byte und sendet die Bestätigung (ACK) zum Gerät. ACK = 1 für das 
letzte zu lesende Byte. Bei ACK =0 folgen noch weitere Byts.*/
{
	if (Bestaetigung == 0) return (i2c_readAck());
	else return (i2c_readNak());
}



uint8_t Lese_Byte_von_Adresse(uint8_t Adresse_Geraet, uint16_t Adresse, uint8_t Adresse8_16)
{
  uint8_t Wert;

    i2c_init();

    i2c_start_wait(Adresse_Geraet);
    if (Adresse8_16 == 1) i2c_write((uint8_t)Adresse);	//8Bit-Zeiger auf Adresse im Gerät
	if (Adresse8_16 == 2)
	{
	  if (i2c_write((uint8_t)(Adresse>>8))) Fehler1 = 0x04;	//H-Byte schreiben
	  if (i2c_write((uint8_t)(Adresse & 0x00ff))) Fehler1 = 0x05;	//L_Byte schreiben
	}  
   i2c_rep_start(Adresse_Geraet | 1);
    Wert = i2c_readNak();
    i2c_stop();
   return Wert;
   
}

void Schreibe_Byte_an_Adresse(uint8_t Adresse_Geraet, uint16_t Adresse, uint8_t Wert, uint8_t Adresse8_16)
{
    i2c_init();

    i2c_start_wait(Adresse_Geraet);	
    if (Adresse8_16 == 1) i2c_write((uint8_t)Adresse);	//8Bit-Zeiger auf Adresse im Gerät
    if (Adresse8_16 == 2)
    {
	if (i2c_write((uint8_t)(Adresse>>8))) Fehler1 = 0x66;	//H-Byte schreiben
	if (i2c_write((uint8_t)(Adresse & 0x00ff))) Fehler1 = 0x77;	//L_Byte schreiben
    }  
    if (i2c_write(Wert)) Fehler1 = 0x88;

    i2c_stop();
  return;
}



void Schreibe_Byts_ab_Adresse(uint8_t Adresse_Geraet, uint16_t Adresse, uint8_t Wert[], uint8_t Anzahl, uint8_t Adresse8_16)
//Es wird die Anzahl der Bytes von dem Feld Wert ab die 
//angegebene Adresse geschrieben. Achtung die Größe des Feldes muß 
//höher oder mindestens gleich der Anzahl sein. Maximal 128 Byte
{
	uint8_t n;
    
	i2c_init();
	i2c_start_wait(Adresse_Geraet);
	if (Adresse8_16 == 1) i2c_write((uint8_t)Adresse);	//8Bit-Zeiger auf Adresse im Gerät
	if (Adresse8_16 == 2)
	{
	  i2c_write((uint8_t)(Adresse>>8));	//H-Byte schreiben
	  i2c_write((uint8_t)(Adresse & 0x00ff));	//L_Byte schreiben
	}  

	for (n=0; n<Anzahl; n++)
	{
		i2c_write(Wert[n]);
	}

	i2c_stop();
}


void Lese_Byts_ab_Adresse(uint8_t Adresse_Geraet, uint16_t Adresse, uint8_t Wert[], uint8_t Anzahl, uint8_t Adresse8_16)
{
  uint8_t n;
	
	i2c_init();
	i2c_start_wait(Adresse_Geraet);
	if (Adresse8_16 == 1) i2c_write((uint8_t)Adresse);	//8Bit-Zeiger auf Adresse im Gerät
	if (Adresse8_16 == 2)
	{
	  i2c_write((uint8_t)(Adresse>>8));	//H-Byte schreiben
	  i2c_write((uint8_t)(Adresse & 0x00ff));	//L_Byte schreiben
	}  
	if (Adresse_Geraet == 0xAC) i2c_stop();	//für Uhr RV3029
	i2c_rep_start(Adresse_Geraet | 1);	//Adresse und Bit zum Lesen einstellen und warte bis Gerät bereit
	for (n=0; n<(Anzahl - 1); n++)
	{
		Wert[n] = i2c_readAck();
	}
	Wert[n] = i2c_readNak();
	
	i2c_stop();
  return;
}

uint16_t Luftdruck_lesen()
{
  //Liest den Luftdruckwert von HP03
  uint16_t Luftdruck;
  
    Schreibe_Byte_an_Adresse(0xEE,0x00FF,0xF0,1);
    warte_us(40000);
    i2c_start_wait(0xEE);
    Schreibe_Byte(0xFD);
    i2c_rep_start(0xEF);

    Luftdruck = (Lese_Byte(ACK)<<8);
    Luftdruck += Lese_Byte(NACK);
    i2c_stop();
    
    return Luftdruck;
}

uint16_t Temperatur_lesen()
{
  //Liest den Temperaturwert von HP03
  uint16_t Temperatur;
  
    Schreibe_Byte_an_Adresse(0xEE,0x00FF,0xE8,1);
    warte_us(40000);
    i2c_start_wait(0xEE);
    Schreibe_Byte(0xFD);
    i2c_rep_start(0xEF);

    Temperatur = (Lese_Byte(ACK)<<8);
    Temperatur += Lese_Byte(NACK);
    i2c_stop();
    
    return Temperatur;
}

#endif
