//Berechnung der Temperatur, der Feuchtigkeit und des Drucks aus den Rohdaten des BME280
//Programm zur Korrektur aus dem Datenblatt von Bosch

/*
 * Register Adressen der Parameter LSB zuerst. Am Schluss Beispielwerte
  dig_T1	0x88/0x89	uint16		28093
  dig_T2	0x8A/0x8B	int16		26325
  dig_T3	0x8C/0x8D	int16		50
  
  dig_P1	0x8E/0x8F	uint16
  dig_P2	0x90/0x91	int16
  dig_P3	0x92/0x93	int16
  dig_P4	0x94/0x95	int16
  dig_P5	0x96/0x97	int16
  dig_P6	0x98/0x99	int16
  dig_P7	0x9A/0x9B	int16
  dig_P8	0x9C/0x9D	int16
  dig_P9	0x9E/0x9F	int16
  
  dig_H1	0xA1		uint8
  dig_H2	0xE1/0xE2	int16
  dig_H3	0xE3		uint8
  dig_H4	0xE5[0:3]/E4	int16
  dig_H5	0xE5[7:4]/0xE6	int16
  dig_H6	0xE7		uint8
  
  Register Adressen der Rohdaten
  F_lsb		0xFE
  F_msb		0xFD
  
  T_xlsb	0xFC[7:4]
  T_lsb		0xFB
  T_msb		0xFA
  
  P_xlsb	0xF9[7:4]
  P_lsb		0xF8
  P_msb		0xF7
  */

#include "./i2c1.h"

//Unterprogramme
  int8_t BME_280_test();
  void BME_280_init();
  void BME_280_Parameter_lesen();
  int32_t Temperatur_roh();
  int32_t Druck_roh();
  int32_t Feuchtigkeit_roh();
  int32_t Temperatur_kompensiert (int32_t adc_T);
  //uint32_t Druck_kompensiert_64Bit (int32_t adc_P);
  uint32_t Druck_kompensiert_32Bit (int32_t adc_P);
 // uint32_t Feuchte_kompensiert (int32_t adc_H);
//Ende Unterprogramme
  
#define BME_280_Adresse 0xEE
uint8_t Platz[16];
//Globale Variable
struct BME_280_Kalibrierung 
{
  uint16_t dig_T1; 
  int16_t dig_T2;
  int16_t dig_T3;
  
  uint16_t dig_P1;
  int16_t dig_P2;
  int16_t dig_P3;
  int16_t dig_P4;
  int16_t dig_P5;
  int16_t dig_P6;
  int16_t dig_P7;
  int16_t dig_P8;
  int16_t dig_P9;
  
  uint8_t dig_H1;
  int16_t dig_H2;
  uint8_t dig_H3;
  int16_t dig_H4;
  int16_t dig_H5;
  int8_t dig_H6;
} cal;

volatile int32_t t_fine;	//Variable wird bei der Temperatur_kompensiert berechnet und für Druck und Feuchte gebraucht
//Ende globale Variable

int8_t BME_280_test()
//Hiermit wird die ID Nr. getestet, und damit ob der Sensor funktioniert
{
  if (Lese_Byte_von_Adresse(BME_280_Adresse, 0xD0, 1) == 0x60)
  {
    return(0);
  }
  else
  {
    return(-1);
  }
}

void BME_280_init()
// Der Sensor wird initialisiert. Im forced Mode, ohne Filter und alle Messwerte einfach
//Die Messzeit beträgt dann maximal 10ms.
  #define filter 0x02	//Filterkoeffizient 4
  #define osrs_h 0x01	//feuchtigkeit 1x oversampling 
  #define osrs_p 0x01	//Druck 1x oversampling 
  #define osrs_t 0x01	//Temperatur 1x oversamplung
  #define mode 0x01	//Mode: forced mode
  #define t_sb 0x00	// Verzögerungszeit beim Normalmodus
  #define spi3w_en 0x00	//aktivire 3 Draht Modus , wenn SPI aktiviert


  #define Adr_F5 ((t_sb << 5) | (filter << 2) | spi3w_en)
  #define Adr_F4 ((osrs_t << 5) | (osrs_p << 2) | mode)
  #define Adr_F2 osrs_h

{
  Schreibe_Byte_an_Adresse(BME_280_Adresse, 0xF2, Adr_F2, 1);
  Schreibe_Byte_an_Adresse(BME_280_Adresse, 0xF5, Adr_F5, 1);
  Schreibe_Byte_an_Adresse(BME_280_Adresse, 0xF4, Adr_F4, 1);	//hiermit statet die Messung 
  return;
}

void BME_280_Parameter_lesen()
//Die Parameter zur Korrektur der Rohdaten werden gelesen und 
//formatiert in die struct Variable cal geschrieben.
{
  uint8_t param[26], param1[7];	//Parameterrohdaten aus dem Sensor
  
  Lese_Byts_ab_Adresse(BME_280_Adresse, 0x88, param, 26, 1);
  Lese_Byts_ab_Adresse(BME_280_Adresse, 0xE1, param1, 7, 1);
  
  cal.dig_T1 = (uint16_t)(((uint16_t)param[1] << 8) | (uint16_t)param[0]);
  cal.dig_T2 = (int16_t)(((int16_t)param[3] << 8) | (int16_t)param[2]);
  cal.dig_T3 = (int16_t)(((int16_t)param[5] << 8) | (int16_t)param[4]);
  
  cal.dig_P1 = (uint16_t)(((uint16_t)param[7] << 8) | (uint16_t)param[6]);
  cal.dig_P2 = (int16_t)(((int16_t)param[9] << 8) | (int16_t)param[8]);
  cal.dig_P3 = (int16_t)(((int16_t)param[11] << 8) | (int16_t)param[10]);
  cal.dig_P4 = (int16_t)(((int16_t)param[13] << 8) | (int16_t)param[12]);
  cal.dig_P5 = (int16_t)(((int16_t)param[15] << 8) | (int16_t)param[14]);
  cal.dig_P6 = (int16_t)(((int16_t)param[17] << 8) | (int16_t)param[16]);
  cal.dig_P7 = (int16_t)(((int16_t)param[19] << 8) | (int16_t)param[18]);
  cal.dig_P8 = (int16_t)(((int16_t)param[21] << 8) | (int16_t)param[20]);
  cal.dig_P9 = (int16_t)(((int16_t)param[23] << 8) | (int16_t)param[22]);
  
  cal.dig_H1 = param[25];
  cal.dig_H2 = (int16_t)(((int16_t)param1[1] << 8) | (int16_t)param1[0]);
  cal.dig_H3 = param1[2];
  cal.dig_H4 = (int16_t)(((int16_t)param1[3] << 4) | ((int16_t)param1[4] & 0x0F));
  cal.dig_H5 = (int16_t)(((int16_t)param1[5] << 4) | (((int16_t)param1[4] & 0xF0) >> 4));
  cal.dig_H6 = (int8_t)param1[6];
  return;
}

int32_t Temperatur_roh()
//Die Temperaturdaten T_msb(0xFA), T_lsb(0xFB) und T_xlsb(0xFC) werden vom Sensor gelesen
//und als int32 Zahl formatiert ausgegeben
{
  uint8_t param_T[3];
  int32_t T;
  
  Lese_Byts_ab_Adresse(BME_280_Adresse, 0xFA, param_T, 3, 1);
  
  T = (int32_t)(((uint32_t)param_T[0] << 12) | ((uint32_t)param_T[1] << 4) | ((uint32_t)param_T[2] >> 4));
  
  return T;
}
  
int32_t Druck_roh()
//Die Druckdaten P_msb(0xF7), P_lsb(0xF8) und P_xlsb(0xF9) werden vom Sensor gelesen
//und als int32 Zahl formatiert ausgegeben
{
  uint8_t param_P[3];
  int32_t P;
  
  Lese_Byts_ab_Adresse(BME_280_Adresse, 0xF7, param_P, 3, 1);
  
  P = (int32_t)(((uint32_t)param_P[0] << 12) | ((uint32_t)param_P[1] << 4) | ((uint32_t)param_P[2] >> 4));
  
  return P;
}

int32_t Feuchtigkeit_roh()
//Die Feuchtedaten F_msb(0xFD und F_lsb(0xFE) werden vom Sensor gelesen und als int32 Zahl formatiert ausgegeben
{
  uint8_t param_F[2];
  int32_t F;
  
  Lese_Byts_ab_Adresse(BME_280_Adresse, 0xFD, param_F, 2, 1);
   
  F = (int32_t)(((uint32_t)param_F[0] << 8) | ((uint32_t)param_F[1]));
  
  return F;
}


int32_t Temperatur_kompensiert (int32_t adc_T)
//Die Daten vom Sensor adc_T werden mit den Koeffizienten dig_T1, dig_T2 und dig_T3 zur Temperatur in °C berechnet.
//Die Ausgangszahl wird als ganze Zahl in hunderstel grd ausgegeben. (1234 = 12,34 °C)
{
  //int32_t t_fine: globale Variable wird hier berechnet.
  int32_t var1, var2, T;
  
  var1 = ((((adc_T >> 3) - ((int32_t)cal.dig_T1 << 1))) * ((int32_t)cal.dig_T2)) >> 11;
  var2 = (((((adc_T >> 4) - ((int32_t)cal.dig_T1)) * ((adc_T >> 4) - ((int32_t)cal.dig_T1))) >> 12) * ((int32_t)cal.dig_T3)) >> 14;
  t_fine = var1 + var2;
  T = (t_fine * 5 + 128) >> 8;
  return (T);
}
/*
uint32_t Druck_kompensiert_64Bit (int32_t adc_P)
// Die Rohdaten adc_P vom Sensor werden mit den Koeffizienten dig_P1 ... dig_p9 zum Druck in Pa berechnet.
//Die Ausgangsdaten liegen im Format 24,8 Bit vor. 24 Bit Ganzzahl und 8 Bit Nachkommastellen
// Teilt man den Wert durch 256, erhält man den Ganzzahlwert in Pa
{
  //int32_t t_fine; globale Variable wird im UP Temperatur_kompensiert() berechnet.
  int64_t var1, var2, p;
  
  var1 = ((int64_t)t_fine) - 128000;
  var2 = var1 * var1 * (int64_t)cal.dig_P6;
  var2 = var2 + ((var1 * (int64_t)cal.dig_P5) << 17);
  var2 = var2 + (((int64_t)cal.dig_P4) << 35);
  var1 = ((var1 * var1 * (int64_t)cal.dig_P3) >> 8) + ((var1 * (int64_t)cal.dig_P2) << 12);
  var1 = (((((int64_t)1) << 47) + var1)) * ((int64_t)cal.dig_P1 >> 33);
  if (var1 == 0)
  {
    return 0;
  }
  p = 1048576 - adc_P;
  p = (((p << 31) - var2) * 3125)/var1;
  var1 = (((int64_t)cal.dig_P9) * (p >> 13) * (p >> 13)) >> 25;
  var2 = (((int64_t)cal.dig_P8) * p) >> 19;
  p = ((p + var1 + var2) >> 8) * (((int64_t)cal.dig_P7) << 4);
  return (uint32_t)p;
}
*/
uint32_t Druck_kompensiert_32Bit (int32_t adc_P)
//Die Rohdaten vom Sensor adc_P werden mit den Koeffizienten dig_P1 ... dig_P9 zum Druck Pa berechnet.
// die Ausgangsdaten liegen als Ganzzahl in Pascal vor.
{
  //int32_t t_fine; globale Variable wird im UP Temperatur_kompensiert() berechnet.
  int32_t var1, var2;
  uint32_t p;
  
  var1 = (((int32_t)t_fine) >> 1) - (int32_t)64000;
  var2 = (((var1 >> 2) * (var1 >> 2)) >> 11) * ((int32_t)cal.dig_P6);
  var2 = var2 + ((var1 * ((int32_t)cal.dig_P5)) << 1);
  var2 = (var2 >> 2) + (((int32_t)cal.dig_P4) << 16);
  var1 = (((cal.dig_P3 * (((var1 >> 2) * (var1 >> 2)) >> 13)) >> 3) + ((((int32_t)cal.dig_P2) * var1) >> 1)) >>18;
  var1 = ((((32768 + var1)) * ((int32_t)cal.dig_P1)) >> 15);
  if (var1 == 0)
  {
    return 0;
  }
  p = (((uint32_t)(((int32_t)1048576) - adc_P) - (var2 >> 12))) * 3125;
  if (p < 0x80000000)
  {
    p = (p << 1)/((uint32_t)var1);
  }
  else
  {
    p = (p/(uint32_t)var1) * 2;
  }
  var1 = (((int32_t)cal.dig_P9) * ((int32_t)(((p >> 3) * (p >> 3)) >> 13))) >> 12;
  var2 = (((int32_t)(p >> 2)) * ((int32_t)cal.dig_P8)) >> 13;
  p = (uint32_t)((int32_t)p + ((var1 + var2 + cal.dig_P7) >> 4));
  return p;
}
  
uint32_t Feuchte_kompensiert (int32_t adc_H)
// Die Rohdaten adc_H vom Sensor werden mit den Koeffizienten did_H1 ... dig_H5 zur Feuchte berechnet.
// der Ausgangswert liegt im Format 22,10 Bit vor. 22 Bit Ganzzahl und 10 Bit Nochkommazahl.
// teilt man den Wert durch 1024 liegt die Feuchte als Ganzzahl vor.
{
  //int32_t t_fine; globale Variable wird im UP Temperatur_kompensiert() berechnet.
  int32_t var1;
   
  var1 = (t_fine - ((int32_t)76800));
  var1 = (((((adc_H << 14) - (((int32_t)cal.dig_H4) << 20) - (((int32_t)cal.dig_H5) * var1)) +\
  ((int32_t)16384)) >> 15) * (((((((var1 * ((int32_t)cal.dig_H6)) >> 10) * (((var1 *\
  ((int32_t)cal.dig_H3)) >> 11) + ((int32_t)32768))) >> 10) + ((int32_t)2097152)) *\
  ((int32_t)cal.dig_H2) + 8192) >> 14));
  
  var1 = (var1 - (((((var1 >>15) * (var1 >> 15)) >> 7) * ((int32_t)cal.dig_H1)) >> 4));
 
  if (var1 < 0)  var1 = 0;
  if (var1 > 419430400) var1 = 419430400;
 
   return (uint32_t)(var1 >> 12);
}
  
   
