//Programm liest die Daten Temperatur, Druck und Feuchtigkeit vom Sensor BME_280 und bringt sie zur Anzeige
//auf einem LCD Display 2x16 Zeichen.

//Prozessor: ATMEGA 48 e-Fuse 01h; h-Fuse DFh; l-Fuse E7h; lock 3Fh. externer Quarz 8MHz

#include <stdlib.h>
#include <avr/wdt.h>
#include <avr/interrupt.h>
//#include <avr/eeprom.h>
#include <util/twi.h>
#include "bibliothek/warte.h"
#include "bibliothek/lcd.h"
#include "bibliothek/BME_Berechnung.c"

extern uint8_t Platz[16];

void Start()
{
  Lcd_Init();
  Lcd_Ausgabe_String(0,0,"BME 280 Funktion");
  warte_sek(5);
}

int main(void)
{
 int32_t Temperatur;
 uint32_t Feuchtigkeit;
 uint32_t Druck;
 uint8_t eine_nkstelle;	//Nachkommastelle Feuchtigkeit
 
  Start();
  
 BME_280_init();
 warte_us(20000);
 //if (BME_280_test() == 0)  Lcd_Ausgabe_String(0,1,"BME280  gut");
 BME_280_Parameter_lesen();
 //warte_sek(2);
 
 while(1)
 {
   // Lcd_Ausgabe_String(0,0,"                ");
     Lcd_Ausgabe_String(0,1,"                ");
  BME_280_init();
  
  Temperatur = Temperatur_kompensiert(Temperatur_roh());
  utoa(Temperatur/10,Platz,10);	//Nur eine Nachkommastelle
  Lcd_Ausgabe_String(0,1,Platz);
 // Feuchter = Feuchtigkeit_roh();
 // utoa(Feuchter,Platz,10);	//ganzzahliger Wert
  //Lcd_Ausgabe_String(4,1,Platz);
  Feuchtigkeit = Feuchte_kompensiert(Feuchtigkeit_roh());	
   utoa(Feuchtigkeit>>10,Platz,10);	//ganzzahliger Wert
  Lcd_Ausgabe_String(4,1,Platz);
  eine_nkstelle = (uint8_t) ((((Feuchtigkeit) & 0x3FF) * 10) >> 10);	//Nachkommastelle
   utoa(eine_nkstelle,Platz,10);
  Lcd_Ausgabe_String(6,1,Platz);
 
  Druck = Druck_kompensiert_32Bit(Druck_roh());
   utoa((Druck/10)-14,Platz,10);	//Korrektur -1,4hPa
  Lcd_Ausgabe_String(10,1,Platz);

  warte_sek(1);
 }
  return(0);
}